'''''
'GBP 2021 - V3.3
'Micromite MKII vers 5.0502 Digital ohm meter. 
'Measures an unknown resistance using a Voltage Divider through an DAC module
'option display - OPTION LCDPANEL ILI9341, LANDSCAPE, 22, 16, 15
'option touch - OPTION TOUCH 23, 21
'I2C open 100,1000:I2C write &H68,0,1,&H8C = set to 18bits 
'ADC = 131071 Max Code and 1 shot conversation, 15.625uV LSB value at +/-2.048 Voltage reference
'''''
Option autorun on
Option explicit 
'Stanadrd Resistors values
Data 1.0, 1.1, 1.2, 1.3, 1.5, 1.6, 1.8, 2.0, 2.2, 2.4, 2.7, 3.0, 3.3, 3.6, 3.9, 4.3, 4.7
Data 5.1, 5.6, 6.2, 6.8, 7.5, 8.2, 9.1, 10, 11, 12, 13, 15, 16, 18, 20
Data 22, 24, 27, 30, 33, 36, 39, 43, 47, 51, 56, 62, 68, 75, 82
Data 91, 100, 110, 120, 130, 150, 160, 180, 200, 220, 240, 270, 300, 330, 360,390
Data 430, 470, 510, 560, 620, 680, 750, 820, 910, 1000, 1100, 1200, 1300, 1500, 1600
Data 1800, 2000, 2200, 2400, 2700, 3000, 3300, 3600, 3900, 4300, 4700, 5100, 5600, 6200, 6800
Data 7500, 8200, 9100, 10000, 11000, 12000, 13000, 15000, 16000, 18000, 20000,22000, 24000, 27000, 30000
Data 33000, 36000, 39000, 43000, 47000, 51000, 56000, 62000, 68000, 75000, 82000, 91000, 100000, 110000, 120000
Data 130000, 150000, 160000, 180000, 200000, 220000, 240000, 270000, 300000, 330000 ,360000, 390000, 430000, 470000, 510000
Data  560000, 620000, 680000, 750000, 820000, 910000, 1000000, 1100000, 1200000, 13000000, 1500000

Dim Rref(4) = ( 100, 1000, 10000, 100000, 1000000)     'Voltage divider (- end), resistor range reference 
dim Rfixed = 100                              'Voltage divider (+ end), fixed R value
Dim Vin as float                              'Voltage supply to voltage divider resistors
Dim ADClsb = 0.000015625                      'ADC lsb value in volts
Dim Ulimit = 1.015                            'Standard Resistor lower range limit -1.5%
Dim Llimit = 0.985                            'Standard Resistor upper range limit +1.5%
Dim endsetting = 0                            'Indicates end of variables inputs
Dim Vaverage As float                         'ADC voltage average reading (10 readings)
Dim a As integer                              'Calculation variable used by ADC and Touch
Dim b As integer                              'Calculation variable used by ADC and Touch
Dim y As integer                              'Variable used for Resistor colour code selection
Dim x As integer                              'Variable used for TOUCH 
Dim InputValue As string                      'Variable used for new data input
Dim Rdata As integer                          'Variable used to read Resistor values Data
Dim Rcolour$ As string                        'String used to select Resistor band colour
Dim PinNo(4)=(4, 5, 6 , 7, 9)                 'Mosfets gate activation pins
Dim ReadADC(4)                                'ADC single binary output codes
Dim ADC As float                              'ADC decimal value
Dim ADCread As string                         'ADC binary number as string
Dim RstandardValue As float                   'Resistor standard value
Dim Rcalibration = 0                          'Short Circuit calibration value
Dim Rx As float                               'Resistor calculated value
Dim ActiveMosfet As integer                   'Mosfet ID in used
dim Radc = 25000000                           'ADC internal resistance
dim Rmos = 0.016                              'Mosfet internal resistance
Dim InputText As string                       'Variable input values
dim exist as string                           'Presaved variables
'--------------------------------------------------------
Var restore
setpin(24), ain                               'Read Voltage
setpin(26), Din                               'Enable TOUCH
SetPin (2), Din                               'Start Push Button
SetPin (4), dout                              'Control Mosfet 1
SetPin (5), dout                              'Control Mosfet 2
SetPin (6), dout                              'Control Mosfet 3
SetPin (7), dout                              'Control Mosfet 4
SetPin (9), dout                              'Control Mosfet 5
'--------------------------------------------------------
CLS RGB(244,244,244)
Text 15,2, " RESISTANCE METER ",L,1,2,RGB(cyan),RGB(244,244,244)
Text 50,175, "  PUSH START   ",L,1,2,RGB(red),RGB(244,244,244)
Text 5,228,"by: GBP2021",L,,,RGB(yellow),RGB(244,244,244)
Text 172,228, "MicroMite MK2 V5.2",,,,RGB(yellow),RGB(244,244,244)
Text 15,30," ",L,10,2,RGB(244,244,244),RGB(white)
'---------------------------------------------------------
Pin(4)=0                                                 'Set all Relay to OFF state
Pin(5)=0
Pin(6)=0
Pin(7)=0
Pin(9)=0
Do
If pin(26) =1    then
a = Touch(X) : b = Touch(Y)
Pause 100
If a > 60 And a <256 And b >44 And b < 132 And endsetting <> 1  Then setting  'Enter new variables values
end if
If Pin(2)= 1 Then                                           'Start test by pushing button
   Box 60,44,20,88,1,RGB(244,244,244),RGB(244,244,244)      'Clear all bands colours
   Box 110,56,20,66,1,RGB(244,244,244),RGB(244,244,244)
   Box 142,56,20,66,1,RGB(244,244,244),RGB(244,244,244)
   Box 174,56,20,66,1,RGB(244,244,244),RGB(244,244,244)
   Box 236,44,20,88,1,RGB(244,244,244),RGB(244,244,244)
   Box 105,126,110,20,,RGB(244,244,244),RGB(244,244,244)     'Clear Circles
   Box 0,142,320,85,,RGB(244,244,244),RGB(244,244,244)       'Clear R values
ActiveMosfet=0
For ActiveMosfet = 0 To 4                                    'Activate Mosfet
  Circle 110+(ActiveMosfet * 18),135,5,2
  Pin(PinNo(ActiveMosfet))= 1
  ReadADCsub
  Pin(PinNo(ActiveMosfet))=0
 If Vaverage < 0.40 Then
   Next ActiveMosfet
 Else
 Pin(PinNo(ActiveMosfet))=0
  FindRvalue
  ColourInBands
  RstandardValue=0
    Print " V on Rref= ", Vaverage, "  -  Rx= ", Rx   'Console output
    Print                                             'Console output
 End If
End If
 If ActiveMosfet > 4 or Rx <0.0 Then
    Text 150,150, " NO RESISTOR FOUND ",C,1,2,RGB(yellow),RGB(244,244,244)
    Text 150,175, "  OR OUT OF RANGE  ",C,1,2,RGB(yellow),RGB(244,244,244)
 End If
endsetting = 0
Loop
'------------------------
Sub ReadADCsub
pause 100
Vin = 0
Vaverage = 0
I2C open 200,1000 
for x = 1 to 8 
pause 120
I2C write &H68,0,1,&H8C
Pause 300
   I2C read &H68,0,4, ReadADC()
    ADCread$ = Bin$(ReadADC(0),8) + Bin$(ReadADC(1),8) + Bin$(ReadADC(2),8)
     ADC =0
     For a = 8 To 24
      b = Val(Mid$(ADCread$,a,1))
       If b = 1 Then
        ADC=ADC + 2^(24-a)
       Else
        ADC=ADC + 0
       End If
     Next a
Vaverage = Vaverage + (ADC * ADClsb)
Vin = Vin + pin(24) * 2
    Print " ADC= ",ADC,"  -  Vdac= ", ADC * ADClsb, "  -  Vin= ",pin(24) * 2 'Console output
next x
I2C close
Vaverage = Vaverage /8
Vin = Vin /8
end sub
'-----------
Sub FindRvalue

Rx = Vin/Vaverage * 1/((1/(Rref(ActiveMosfet) + Rmos)+ (1/Radc))) - 1/((1/(Rref(ActiveMosfet) + Rmos)+1/Radc)) - Rfixed - Rcalibration
Box 0,142,300,85,,RGB(244,244,244),RGB(244,244,244)
Text 205,200, Str$(Rx,6,2),R,1,2,RGB(yellow),RGB(244,244,244) 'Print actual R value
Text 210,200, " ",L,14,1,RGB(244,244,244),RGB(Yellow)
For Rdata = 0 To 148
Read RstandardValue                     'Find standard value within set limits
 If RstandardValue => (Rx * Llimit) And Rstandardvalue =< (Rx * Ulimit)  Then
 Select Case RstandardValue
  Case < 1000
   Text 190,143, Str$(RstandardValue ),R,1,3,RGB(yellow),RGB(244,244,244)
   Text 205,143, " ",L,11,1,RGB(244,244,244),RGB(Yellow)          'print Ohms
  Case 1000 To 990000
  Text 190,143, Str$(RstandardValue/1000),R,1,3,RGB(yellow),RGB(244,244,244)
  Text 205,143, " ",L,12,1,RGB(244,244,244),RGB(Yellow)           'print Kohms
  Case > 990000
   Text 190,143, Str$(RstandardValue/1000000),R,1,3,RGB(yellow),RGB(244,244,244)
   Text 205,143, " ",L,13,1,RGB(244,244,244),RGB(Yellow)          'print Mohms
 End Select
Else
   Next Rdata
EndIf
Restore                                 'Reset DATA to beginning
End Sub
'-------------------------
Sub ColourInBands
'Set Bands Colours 0=black, 1=brown, 2=red, 3=orange, 4=yellow, 5=green, 6=blue,  7=violet, 8=grey, 9=white, 10=silver, 11=gold
Local BandColour(11)
Bandcolour(0)= RGB(0,0,0)
Bandcolour(1)= RGB(180,55,0)
Bandcolour(2)= RGB(255,0,0)
Bandcolour(3)= RGB(255,175,0)
Bandcolour(4)= RGB(255,255,0)
Bandcolour(5)= RGB(0,255,0)
Bandcolour(6)= RGB(0,0,255)
Bandcolour(7)= RGB(210,125,210)
Bandcolour(8)= RGB(200,200,200)
Bandcolour(9)= RGB(254,254,254)
Bandcolour(10)= RGB(200,200,200)
Bandcolour(11)= RGB(205,175,50)
If Rdata> 148 Then
Text 150,150, "  NO MATCH FOUND  ",C,1,2,RGB(yellow),RGB(244,244,244)
   Box 60,44,20,88,1,RGB(244,244,244),RGB(244,244,244)  'clear all bands colours
   Box 110,56,20,66,1,RGB(244,244,244),RGB(244,244,244)
   Box 142,56,20,66,1,RGB(244,244,244),RGB(244,244,244)
   Box 174,56,20,66,1,RGB(244,244,244),RGB(244,244,244)
   Box 236,44,20,88,1,RGB(244,244,244),RGB(244,244,244)
Else
Rcolour$ = Left$(Str$(Int(RstandardValue)),1)
y = Val(Rcolour$)
Box 60,44,20,88,1,BandColour(y) , BandColour(y)                '1st band
Rcolour$= Mid$(Str$(RstandardValue),2,1)
If Rcolour$="." Then Rcolour$= Mid$(Str$(RstandardValue),3,1)
y= Val(Rcolour$)
Box 110,56,20,66,1,BandColour(y) , BandColour(y)               '2nd band
Box 142,56,20,66,1,BandColour(0) , BandColour(0)               '3rd band, this is always black
 Select Case RstandardValue                                    'Set Multiplier
  Case <10
   Box 174,56,20,66,1,BandColour(10), bandcolour(10)
  Case 10 To 99
   Box 174,56,20,66,1,BandColour(11), bandcolour(11)
  Case 100 To 999
   Box 174,56,20,66,1,BandColour(0), bandcolour(0)
  Case 1000 To 9999
   Box 174,56,20,66,1,BandColour(1), bandcolour(1)
  Case 10000 To 99999
   Box 174,56,20,66,1,BandColour(2), bandcolour(2)
  Case 100000 To 999999
   Box 174,56,20,66,1,BandColour(3), bandcolour(3)
  Case <10000000
   Box 174,56,20,66,1,BandColour(4), bandcolour(4)
 End Select
Box 236,44,20,88,1,RGB(180,55,0), RGB(180,55,0)                   'Resistor Tolerance -  fixed at 1% (brown)
End If
End Sub
'------------------------------------------------------------------------
Sub setting
Box 0,142,320,85,,RGB(244,244,244),RGB(244,244,244)
Box 60,142,200,30,1,RGB(red),RGB(white)
Box 20,180,20,20,1,RGB(black),RGB(Green): Text 26,196,"<",lb,1,1,RGB(black),RGB(green)
Box 50,180,20,20,1,RGB(red),RGB(white): Text 56,196,"1",lb,1,1,RGB(black),RGB(white)
Box 70,180,20,20,1,RGB(red),RGB(white): Text 76,196,"2",lb,1,1,RGB(black),RGB(white)
Box 90,180,20,20,1,RGB(red),RGB(white): Text 96,196,"3",lb,1,1,RGB(black),RGB(white)
Box 110,180,20,20,1,RGB(red),RGB(white): Text 116,196,"4",lb,1,1,RGB(black),RGB(white)
Box 130,180,20,20,1,RGB(red),RGB(white): Text 136,196,"5",lb,1,1,RGB(black),RGB(white)
Box 150,180,20,20,1,RGB(red),RGB(white): Text 156,196,"6",lb,1,1,RGB(black),RGB(white)
Box 170,180,20,20,1,RGB(red),RGB(white): Text 176,196,"7",lb,1,1,RGB(black),RGB(white)
Box 190,180,20,20,1,RGB(red),RGB(white): Text 196,196,"8",lb,1,1,RGB(black),RGB(white)
Box 210,180,20,20,1,RGB(red),RGB(white): Text 216,196,"9",lb,1,1,RGB(black),RGB(white)
Box 230,180,20,20,1,RGB(red),RGB(white): Text 236,196,"0",lb,1,1,RGB(black),RGB(white)
Box 250,180,20,20,1,RGB(red),RGB(white): Text 256,196,".",lb,1,1,RGB(black),RGB(white)
Box 280,180,25,20,1,RGB(black),RGB(Green): Text 286,196,"Ok",lb,1,1,RGB(black),RGB(green)

InputText$ = "Enter Rfixed value"
Exist$ = str$(Rfixed )
EnterValue
Rfixed  = val(InputValue$)

InputText$ = "Enter Rref 1 value"
Exist$ = str$(Rref(0))
EnterValue 
Rref(0) = val(InputValue$)

InputText$ = "Enter Rref 2 value"
Exist$ = str$(Rref(1))  
EnterValue 
Rref(1) = val(InputValue$)

InputText$ = "Enter Rref 3 value"
Exist$ = str$(Rref(2)) 
EnterValue 
Rref(2) = val(InputValue$)

InputText$ = "Enter Rref 4 value"
Exist$ = str$(Rref(3)) 
EnterValue 
Rref(3) = val(InputValue$)

InputText$ = "Enter Rref 5 value"
Exist$ = str$(Rref(4)) 
EnterValue 
Rref(4) = val(InputValue$)

InputText$ = "Enter Rx upper limits"
Exist$ = Str$(Ulimit)
EnterValue
Ulimit = Val(InputValue$)

InputText$ = "Enter Rx lower limits"
Exist$ = Str$(Llimit)
EnterValue
Llimit = Val(InputValue$)

InputText$ = "Enter Short Circuit value"
Exist$ = Str$(Rcalibration)
EnterValue
Rcalibration = Val(InputValue$)

endsetting = 1

Var save Rfixed, Rref(), Ulimit, Llimit, Rcalibration
Box 0,142,320,85,,RGB(244,244,244),RGB(244,244,244)
Text 50,175, "  PUSH START   ",L,1,2,RGB(red),RGB(244,244,244)
Pause 100
End Sub
'------------------------------------------------------------------------
Sub EnterValue
Box 60,142,200,30,1,RGB(red),RGB(white)
Text 161,148, InputText$,c,1,1,RGB(black),RGB(white)
InputValue$ = Exist$
Do While Touch(x) = -1 : Loop
Box 60,142,200,30,1,RGB(red),RGB(white)
Text 161,148, Exist$,c,1,1,RGB(black),RGB(white)
Pause 500
Do While Touch(x) = -1 : Loop

Do
a = Touch(X): b = Touch(Y)
Do While Touch(x) <> -1 : Loop
Pause 200
If b >178 And b < 202 Then
Box 60,142,200,30,1,RGB(red),RGB(white)
Select Case a
Case 20 To 40
 a = Len(InputValue$)
 InputValue$= Left$(InputValue$, a-1)
 If InputValue$ = "" Then InputValue$ = "  "
 Text 161,148, " " + InputValue$ + " ",c,1,1,RGB(black),RGB(white)
Case 50 To 70
 InputValue$= InputValue$ + "1"
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 71 To 90
 InputValue$= InputValue$ + "2"
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 91 To 110
 InputValue$= InputValue$ + "3"
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 111 To 130
 InputValue$= InputValue$ + "4"
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 131 To 150
 InputValue$= InputValue$ + "5"
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 151 To 170
 InputValue$= InputValue$ + "6"
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 171 To 190
 InputValue$= InputValue$ + "7"
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 191 To 210
 InputValue$= InputValue$ + "8"
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 211 To 230
 InputValue$= InputValue$ + "9"
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 231 To 250
 InputValue$= InputValue$ + "0"
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 250 To 270
 InputValue$= InputValue$ + "."
 Text 161,148, InputValue$,c,1,1,RGB(black),RGB(white)
Case 280 To 305
  End Sub
End Select
End If
Loop
End Sub
'------------------------------------------------------------------------
'Resistor shape
DefineFont #10
  01204090 FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF 00E0FFFF FFFFFF3F FFFFFFFF 0700E0FF
  FFFFFFFF FF0F0080 FFFFFFFF C0FFFFFF FFFF0100 FF1DFFFF FFFFFF47 FFFFFFFF
  60FF85FF FEFFFFFF FF71FF3D FFFFFFFF 1DFFFFFF FF7F78FF FF7DFCFF FFFFFF78
  FFFFFFFF 7CFF3DFE F8FFFF3F 7F7CFFFD FFFFFFFF 7DFCFFFF FF3F7EFF FFFDF9FF
  0000007E 00000000 7FFFFD00 F1FFFF1F 007EFFFD 00000000 FD000000 FF1F7FFF
  FFFDF3FF BEFF3E7F BFFFBEFF 7FFFFDF9 F3FFFF9F 3E7FFFFD BEFFBEFF FDF9BFFF
  FF9F7FFF FFFDF3FF BEFF3E7F BFFFBEFF 7FFFFDF9 F3FFFF9F 3E7FFFFD BEFFBEFF
  FDF9BFFF FF9F7FFF FFFDF3FF BEFF3E7F BFFFBEFF 7FFFFDF9 F3FFFF9F 3E7FFFFD
  BEFFBEFF FDF9BFFF FF9F7FFF FFFDF3FF BEFF3E7F BFFFBEFF 7FFFFDF9 F3FFFF9F
  3E7FFFFD BEFFBEFF FDF9BFFF FF9F7FFF FFFDF3FF BEFF3E7F BFFFBEFF 7FFFFDF9
  F3FFFF9F 3E7FFFFD BEFFBEFF FDF9BFFF FF9F7FFF FFFDF3FF BEFF3E7F BFFFBEFF
  7FFFFDF9 F3FFFF9F 3E7FFFFD BEFFBEFF FDF9BFFF FF9F7FFF FFFDF3FF BEFF3E7F
  BFFFBEFF 7FFFFDF9 0300FF9F 3E7FFFFD BEFFBEFF FDF9BFFF 00807FFF FFFD0300
  BEFF3E7F BFFFBEFF 7FFFFDF9 03000080 3E7FFFFD BEFFBEFF FDF9BFFF 00807FFF
  FFFD0300 BEFF3E7F BFFFBEFF 7FFFFDF9 03000080 3E7FFFFD BEFFBEFF FDF9BFFF
  00807FFF FFFD0300 BEFF3E7F BFFFBEFF 7FFFFDF9 F3FF0080 3E7FFFFD BEFFBEFF
  FDF9BFFF FF9F7FFF FFFDF3FF BEFF3E7F BFFFBEFF 7FFFFDF9 F3FFFF9F 3E7FFFFD
  BEFFBEFF FDF9BFFF FF9F7FFF FFFDF3FF BEFF3E7F BFFFBEFF 7FFFFDF9 F3FFFF9F
  3E7FFFFD BEFFBEFF FDF9BFFF FF9F7FFF FFFDF3FF BEFF3E7F BFFFBEFF 7FFFFDF9
  F3FFFF9F 3E7FFFFD BEFFBEFF FDF9BFFF FF9F7FFF FFFDF3FF BEFF3E7F BFFFBEFF
  7FFFFDF9 F3FFFF9F 3E7FFFFD BEFFBEFF FDF9BFFF FF9F7FFF FFFDF3FF BEFF3E7F
  BFFFBEFF 7FFFFDF9 F3FFFF9F 3E7FFFFD BEFFBEFF FDF9BFFF FF9F7FFF FFFDF3FF
  BEFF3E7F BFFFBEFF 7FFFFDF9 F1FFFF9F 007EFFFD 00000000 FD000000 FF1F7FFF
  FFFDF9FF 0000007E 00000000 7FFFFD00 F8FFFF1F 7F7CFFFD FFFFFFFF 7DFCFFFF
  FF1F7EFF FF7DFCFF FFFF7F78 FFFFFFFF 7CFF3DFE FEFFFF3F FF70FF3D FFFFFFFF
  1DFEFFFF FF7F78FF FF1DFFFF FFFFFF41 FFFFFFFF 70FF0DFF FFFFFFFF FF070080
  FFFFFFFF 80FFFFFF FFFF0100 00C0FFFF FFFFFF0F FFFFFFFF 0300C0FF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF
End DefineFont
'Ohm symbol small
DefineFont #14
  01201010 0FF8FFFF E3E7C7E3 E1C7E3E7 F1C7F1C7 E3C7E3C7 CFFBE7E7 C181DDFB
  FFFF8181
End DefineFont
'Ohm symbol large
DefineFont #11
  01202020 FFFFFFFF FF1FF8FF FF03C0FF FFE007FF 7FF81FFE 3FFC3FFC 1FFE7FF8
  0FFFFFF0 0FFFFFF0 87FFFFE1 87FFFFE1 87FFFFE1 87FFFFE1 87FFFFE1 87FFFFE1
  87FFFFE1 87FFFFE1 07FFFFE0 07FFFFE0 0FFFFFF0 1FFE7FF8 3FFE7FF8 7FFC3FFC
  FFF00FFF FDE387BF F9E7E79F 01E00780 01E00780 01E00780 01E00780 FFFFFFFF
  FFFFFFFF
End DefineFont
'KOhm Symbol
DefineFont #12
  01202040 FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF3FF0FF FFFFFFFF
  FF0780FF 0F801F00 FFC10FFE 1FC03F80 FFF03FFC FFF17FC0 7FF87FF8 FFE3FFE0
  3FFCFFF0 FFC7FFE0 1FFEFFE1 FF8FFFE0 1FFEFFE1 FF1FFFE0 0FFFFFC3 FF3FFEE0
  0FFFFFC3 FF7FFCE0 0FFFFFC3 FFFFF8E0 0FFFFFC3 FFFFF0E0 0FFFFFC3 FFFFE0E0
  0FFFFFC3 FFFFC0E0 0FFFFFC3 FF7F80E0 0FFFFFC3 FF3F18E0 0FFEFFC1 FF1F3CE0
  0FFEFFC1 FF0F7EE0 1FFEFFE1 FF07FFE0 3FFCFFF0 FF83FFE0 7FFCFFF0 FFC1FFE0
  FFF87FF8 FFE0FFE0 FFE11FFE 7FF0FFE0 FDC70F7F 3FF8FFE0 F9CFCF3F 1FFCFFE0
  01C00F00 0FFC7FC0 01C00F00 07F83F80 01C00F00 03F01F00 01C00F00 FFFFFFFF
  FFFFFFFF
End DefineFont
'MOhm Symbol
DefineFont #13
  01202040 FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF 03F0FF80 FF3FF0FF 07F8FFC1
  FF0780FF 0FFCFFE3 FFC10FFE 1FFCFFE1 FFF03FFC 1FF8FFE0 7FF87FF8 1FF0FFE0
  3FFCFFF0 1FF07FE0 1FFEFFE1 1FE27FE2 1FFEFFE1 1FC63FE3 0FFFFFC3 1F863FE3
  0FFFFFC3 1F8E9FE3 0FFFFFC3 1F1E9FE3 0FFFFFC3 1F1ECEE3 0FFFFFC3 1F3ECEE3
  0FFFFFC3 1F7EE4E3 0FFFFFC3 1FFEE0E3 0FFFFFC3 1FFEF1E3 0FFEFFC1 1FFEF1E3
  0FFEFFC1 1FFEFBE3 1FFEFFE1 1FFEFFE3 3FFCFFF0 1FFEFFE3 7FFCFFF0 1FFEFFE3
  FFF87FF8 1FFEFFE3 FFE11FFE 1FFEFFE3 FDC70F7F 1FFEFFE3 F9CFCF3F 1FFEFFE3
  01C00F00 0FFCFFE3 01C00F00 07F8FFC1 01C00F00 03F0FF80 01C00F00 FFFFFFFF
  FFFFFFFF
End DefineFont